clc
clear all
close all
set(0,'defaultTextInterpreter','latex'); %trying to set the default
set(0,'defaultAxesFontSize',20);
set(0,'defaultAxesFontName','TimesNewRoman');

%% CREAZIONE MATRICE DA TXT
pa=101325; %Pa
Spessore=50;%um
ps=4; %bar 
x0=40;%um
D_foro=6;
test=2;

Dati=['load VerificaPattinoC60x30_f' num2str(D_foro) '_' num2str(Spessore) 'um_' num2str(ps) 'bar_x' num2str(x0) '_' num2str(test) '.txt'];
eval(Dati);

Sensore1=['y1=VerificaPattinoC60x30_f' num2str(D_foro) '_' num2str(Spessore) 'um_' num2str(ps) 'bar_x' num2str(x0) '_' num2str(test) '(:,1);'];
Sensore2=['y2=VerificaPattinoC60x30_f' num2str(D_foro) '_' num2str(Spessore) 'um_' num2str(ps) 'bar_x' num2str(x0) '_' num2str(test) '(:,2);'];
Sensore3=['y3=VerificaPattinoC60x30_f' num2str(D_foro) '_' num2str(Spessore) 'um_' num2str(ps) 'bar_x' num2str(x0) '_' num2str(test) '(:,3);'];
Sensore4=['y4=VerificaPattinoC60x30_f' num2str(D_foro) '_' num2str(Spessore) 'um_' num2str(ps) 'bar_x' num2str(x0) '_' num2str(test) '(:,4);'];
Forza=['F=VerificaPattinoC60x30_f' num2str(D_foro) '_' num2str(Spessore) 'um_' num2str(ps) 'bar_x' num2str(x0) '_' num2str(test) '(:,5);'];
Spostamento=['x=VerificaPattinoC60x30_f' num2str(D_foro) '_' num2str(Spessore) 'um_' num2str(ps) 'bar_x' num2str(x0) '_' num2str(test) '(:,8);'];  %per quelle a 5 bar spostamento e pressione sono invertite
Pressione=['p=VerificaPattinoC60x30_f' num2str(D_foro) '_' num2str(Spessore) 'um_' num2str(ps) 'bar_x' num2str(x0) '_' num2str(test) '(:,7);'];
Portata=['Q=VerificaPattinoC60x30_f' num2str(D_foro) '_' num2str(Spessore) 'um_' num2str(ps) 'bar_x' num2str(x0) '_' num2str(test) '(:,6);'];

eval(Sensore1);
eval(Sensore2);
eval(Sensore3);
eval(Sensore4);
eval(Forza);
eval(Spostamento);
eval(Pressione);
eval(Portata);

P=p*1e5+pa;

%Riordina le x 
xi=x(1)+x0;
x=xi-x;

%% Separazione primo-secondo tratto
% Dati
a=6.7*1e-3/2;    %raggio membrana [m]
E=201e9;            %Modulo di Young [N/m^2]
nu=0.3;             %Coeff. di Poisson

%Divisione Curve
Qi=0.881; %l/min
[val1, ind1]=min(abs(Q-Qi));
ind1=600;
x1=x(1:ind1)*1e-6;  %[m]
p1=p(1:ind1)*1e5;   %[Pa]
Q1=Q(1:ind1);       %[l/min]
P1=p1+pa;       %pressione assoluta tratto 1

x2=x(ind1:end)*1e-6;%[m]
p2=p(ind1:end)*1e5; %[Pa]
Q2=Q(ind1:end);     %[l/min]
P2=p2+pa;       %pressione assoluta tratto 2
Ps=ps*1e5+pa;   %pressione assoluta alimentazione

%Calcolo deformazione tratto 1 da pendenza retta interpolante
[valm, indm]=max(P1);
[valm, indmin]=min(P1);
Am=pi*a^2;
k_m1=Am*(P1(indm)-P1(indmin))/(x1(indm)-x1(indmin));  %N/m   area/pendenza retta
x00=x0*1e-6;
w_1=x00+(P1-pa)*Am/k_m1;

figure      %plot spostamenti in funzione della pressione relativa
plot(p*1e5,x*1e-6,'b','Linewidth',4), hold on, 
plot(p1,x1,'ro','Linewidth',4), hold on, 
plot(p2,x2,'go','Linewidth',4), hold on, 
xlabel('$p_{rel.}$ (Pa)'),
ylabel('$x_{capacitivo}$ ($m$)')
grid on, zoom on
legend('completo','primo tratto','secondo tratto')


figure      %plot portata
plot(P./Ps,Q,'b','Linewidth',4),hold on,
plot(P1./(ps*1e5+pa),Q1,'ro','Linewidth',4),hold on,
plot(P2./(ps*1e5+pa),Q2,'go','Linewidth',4),hold on,
xlabel('$\frac{P}{P_s}$ (-)'),
ylabel('$Q$ ($\frac{l}{min}$) ANR 20 $^\circ$')
grid on, zoom on
legend('completo','primo tratto','secondo tratto')


figure      %plot primo tratto
plot(P1,x1,'bo','Linewidth',4),hold on,
plot(P1,w_1,'r','Linewidth',4),hold on,
xlabel('$p_{rel.}$ (Pa)'),
ylabel('$x_{capacitivo}$ ($m$)')
grid on, zoom on
legend('sperimentale','teoria piastre sottilissime')

%% Analisi primo tratto
%Dati
dp=1e-3;        % Diametro del foro di ingresso del pattino (m)
d_ratio=0.5;
dn=0.8e-3;
x_bypass=13;   %[um]
T=293;
Rg=287.053;      % Costante dell'aria [J/Kg/K]
Kt=sqrt(293/T);          %Fattore di correzione della temperatura
psi=0.6855/sqrt(Rg*T);   %Costante nella formula ISO 6358
rho=pa/(Rg*T);           %Densità dell'aria in condizioni normali (kg/m^3)
mu=1.77*1e-5;     % viscosit` dinamica dell'aria a 20 C [Pas]

ck=60000/rho;   % Per passare da (kg/s) a (l/min) ANR 
G2=Q1/ck;
bc=0.5283;
cd_th=0.9;

%Filtro tutti i dati con P1<3 bar per considerare solo il tratto lineare delle x
ind_P1=P1>=3*1e5;
P1=P1(ind_P1);
Q1=Q1(ind_P1);
x1=x1(ind_P1);
G2=G2(ind_P1);
[valm, indm]=max(P1);
[valm, indmin]=min(P1);
k_m=Am*(P1(indm)-P1(indmin))/((x1(indm)-x1(indmin)));  %N/m
x00=x0*1e-6; %dovrebbe essere negativo

for i=1:length(P1)
    X(i)=x00+(P1(i)-pa)*Am/k_m;

    % Verifico se sono in condizioni di x_bypass o meno
    if X(i)<x_bypass*1e-6
        X(i)=x_bypass*1e-6;
    end
    %Formula ISO 6358 Valvole
    %Conduttanza Sezione Anulare 
    Re_a=abs(G2(i))/(pi*mu*X(i));
    cd_a=1.05*(1-0.3*exp(-0.005*Re_a));
    A_a=pi*X(i)*dn;
    cs_a=cd_a*A_a*Kt*psi;      % conduttanza dell'ugello della valvola con sezione ANULARE
    %Conduttanza Sezione Circolare 
    Re_c=4*abs(G2(i))/(pi*mu*dn);
    cd_c=1*(1-exp(-8.2*X(i)/dn))*(1-0.3*exp(-0.001*Re_c));
    A_c=pi*dn^2/4;
    cs_c=cd_c*A_c*Kt*psi;      % conduttanza dell'ugello della valvola con sezione ANULARE
    %Prendo la conduttanza minore
    Cond_cs=cs_c<=cs_a;
    cs(Cond_cs)=cs_c;
    Cond_cs=cs_c>cs_a;
    cs(Cond_cs)=cs_a;
    %Discrimino se flusso sonico/subsonico
    Cond_p=P1(i)/Ps<=bc;
    gu(Cond_p)=cs*Ps;
    gu_th(Cond_p)=cd_th*A_c*Kt*psi*Ps;
    Cond_p=P1(i)/Ps>bc;
    gu(Cond_p)=cs*Ps.*sqrt(1-((P1(i)./Ps-bc)/(1-bc)).^2);
    gu_th(Cond_p)=cd_th*A_c*Kt*psi*Ps*sqrt(1-((P1(i)./Ps-bc)/(1-bc)).^2);

    Qu(i)=gu*ck;
    Cs(i)=cs;
    Q_th(i)=gu_th*ck;
end

figure      %confronto portata sperimentale-teorica
plot(P1./(ps*1e5+pa),Q1,'g','Linewidth',4),hold on,
plot(P1./(ps*1e5+pa),Qu,'b','Linewidth',4),hold on,
plot(P1./(ps*1e5+pa),Q_th,'r','Linewidth',4),hold on,
xlabel('$\frac{P}{P_s}$ (-)'),
ylabel('$Q$ ($\frac{l}{min}$) ANR 20 $^\circ$')
grid on, zoom on
legend('sperimentale','ISO 6358-Modificata','ISO 6358')


figure      %plot tratto lineare
plot(P1,X,'b','Linewidth',4),hold on,
plot(P1,x1,'g','Linewidth',4),hold on,
xlabel('$p_{rel.}$ (Pa)'),
ylabel('$x_{capacitivo}$ ($m$)')
grid on, zoom on
legend('teorica','sperimentale')


%% Controllo spessore
%spessore da k misurato
s_m_inc=((12*k_m*a^2*(1-nu^2))/(64*pi*E))^(1/3)*1e6;
s_m_app=(k_m*12*(1+nu^2)*a^2/(64*pi*E)*(5+nu)/(1+nu))^(1/3)*1e6;

%spessore da k teorico
k_th_inc=64*pi*E*(Spessore*1e-6)^3/(12*(1+nu^2)*a^2);         %Rigidezza [N/m]
s_th_inc=((12*k_th_inc*a^2*(1-nu^2))/(64*pi*E))^(1/3)*1e6;

k_th_app=64*pi*E*(Spessore*1e-6)^3/(12*(1+nu^2)*a^2)*(1+nu)/(5+nu);         %Rigidezza [N/m]
s_th_app=(k_th_app*12*(1+nu^2)*a^2/(64*pi*E)*(5+nu)/(1+nu))^(1/3)*1e6;

%% Salvataggio Automatico
% stringa_x1=['x1_f' num2str(D_foro) '_s' num2str(Spessore)  '_ps' num2str(ps) '_x' num2str(x0) '_' num2str(test) '=x1;'];
% stringa_x2=['x2_f' num2str(D_foro) '_s' num2str(Spessore)  '_ps' num2str(ps) '_x' num2str(x0) '_' num2str(test) '=x2;'];
% stringa_X=['X_f' num2str(D_foro) '_s' num2str(Spessore)  '_ps' num2str(ps) '_x' num2str(x0) '_' num2str(test) '=X;'];
% stringa_P1=['P1_f' num2str(D_foro) '_s' num2str(Spessore)  '_ps' num2str(ps) '_x' num2str(x0) '_' num2str(test) '=P1;'];
% stringa_P2=['P2_f' num2str(D_foro) '_s' num2str(Spessore)  '_ps' num2str(ps) '_x' num2str(x0) '_' num2str(test) '=P2;'];
% stringa_Q1=['Q1_f' num2str(D_foro) '_s' num2str(Spessore)  '_ps' num2str(ps) '_x' num2str(x0) '_' num2str(test) '=Q1;'];
% stringa_Q2=['Q2_f' num2str(D_foro) '_s' num2str(Spessore)  '_ps' num2str(ps) '_x' num2str(x0) '_' num2str(test) '=Q2;'];
% stringa_Qu=['Qu_f' num2str(D_foro) '_s' num2str(Spessore)  '_ps' num2str(ps) '_x' num2str(x0) '_' num2str(test) '=Qu;'];
% % stringa_xfit1=['xfit1_f' num2str(D_foro) '_s' num2str(Spessore)  '_ps' num2str(ps) '_x' num2str(x0) '_' num2str(test) '=w_s_fit1*1e6;'];
% % stringa_xfit2=['xfit2_f' num2str(D_foro) '_s' num2str(Spessore)  '_ps' num2str(ps) '_x' num2str(x0) '_' num2str(test) '=w_s_fit2*1e6;'];
% stringa_k=['k_f' num2str(D_foro) '_s' num2str(Spessore)  '_ps' num2str(ps) '_x' num2str(x0) '_' num2str(test) '=k_m;'];
% 
% 
% Salvataggio=['save Test_Pattino_f' num2str(D_foro) '_s' num2str(Spessore)  '_ps' num2str(ps) '_x' num2str(x0) '_' num2str(test) ' x1_f' num2str(D_foro) '_s' num2str(Spessore)  '_ps' num2str(ps) '_x' num2str(x0) '_' num2str(test) ' x2_f' num2str(D_foro) '_s' num2str(Spessore)  '_ps' num2str(ps) '_x' num2str(x0) '_' num2str(test) ' X_f' num2str(D_foro) '_s' num2str(Spessore)  '_ps' num2str(ps) '_x' num2str(x0) '_' num2str(test) ' P1_f' num2str(D_foro) '_s' num2str(Spessore)  '_ps' num2str(ps) '_x' num2str(x0) '_' num2str(test) ' P2_f' num2str(D_foro) '_s' num2str(Spessore)  '_ps' num2str(ps) '_x' num2str(x0) '_' num2str(test) ' Q1_f' num2str(D_foro) '_s' num2str(Spessore)  '_ps' num2str(ps) '_x' num2str(x0) '_' num2str(test) ' Q2_f' num2str(D_foro) '_s' num2str(Spessore)  '_ps' num2str(ps) '_x' num2str(x0) '_' num2str(test) ' Qu_f' num2str(D_foro) '_s' num2str(Spessore)  '_ps' num2str(ps) '_x' num2str(x0) '_' num2str(test) ' k_f' num2str(D_foro) '_s' num2str(Spessore)  '_ps' num2str(ps) '_x' num2str(x0) '_' num2str(test)];
% 
% eval(stringa_x1)
% eval(stringa_x2)
% eval(stringa_X)
% eval(stringa_P1)
% eval(stringa_P2)
% eval(stringa_Q1)
% eval(stringa_Q2)
% eval(stringa_Qu)
% % eval(stringa_xfit1)
% % eval(stringa_xfit2)
% eval(stringa_k)
% 
% 
% eval(Salvataggio)

